/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import com.jhlabs.composite.RGBComposite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class DodgeComposite
extends RGBComposite {
    public DodgeComposite(float alpha) {
        super(alpha);
    }

    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new Context(this.extraAlpha, srcColorModel, dstColorModel);
    }

    static class Context
    extends RGBComposite.RGBCompositeContext {
        public Context(float alpha, ColorModel srcColorModel, ColorModel dstColorModel) {
            super(alpha, srcColorModel, dstColorModel);
        }

        public void composeRGB(int[] src, int[] dst, float alpha) {
            int w = src.length;
            for (int i2 = 0; i2 < w; i2 += 4) {
                int sr = src[i2];
                int dir = dst[i2];
                int sg = src[i2 + 1];
                int dig = dst[i2 + 1];
                int sb = src[i2 + 2];
                int dib = dst[i2 + 2];
                int sa = src[i2 + 3];
                int dia = dst[i2 + 3];
                int dor = Context.clamp((sr << 8) / (256 - dir));
                int dog = Context.clamp((sg << 8) / (256 - dig));
                int dob = Context.clamp((sb << 8) / (256 - dib));
                float a2 = alpha * (float)sa / 255.0f;
                float ac = 1.0f - a2;
                dst[i2] = (int)(a2 * (float)dor + ac * (float)dir);
                dst[i2 + 1] = (int)(a2 * (float)dog + ac * (float)dig);
                dst[i2 + 2] = (int)(a2 * (float)dob + ac * (float)dib);
                dst[i2 + 3] = (int)((float)sa * alpha + (float)dia * ac);
            }
        }
    }
}

